#!/bin/bash

#this script converts this in a graph.
# typical use: dylibdeps <somelibrary.dylib> | needs2gml.sh > graph.gml

#@param $1=file with lines of the form "X needs Y"
 

nodesfile=/tmp/labels
# sort node names, make unique, add ids
awk '{ print $1; print $3 }' $1 | sort -u | awk 'BEGIN {n=0} {print n++ " " $1 }' > $nodesfile

# $1=filename of file with rules X needs Y 
echo "Creator \"needs2gml\""
echo "graph"
echo "["
echo " hierarchic 1"
echo " label \"\""
echo "directed 1"

# print a gml node for each row in $nodesfile
cat $nodesfile | xargs -n 2 makegmlnode.sh

# convert the needs file into a file with node ids
cat $1 | awk '{ print $1 " " $3 }' | xargs -n 2 makegmledge.sh $nodesfile

echo "]"
